%------------------------------------------------------------------------------
% File     : LCL743^5 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Logical Calculi
% Problem  : TPS problem from AXIOMOFDESCR
% Version  : Especial.
% English  : Related to the axiom of description.

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0707 [Bro09]

% Status   : CounterSatisfiable
% Rating   : 0.00 v4.0.0
% Syntax   : Number of formulae    :    5 (   0 unt;   4 typ;   0 def)
%            Number of atoms       :    5 (   1 equ;   0 cnn)
%            Maximal formula atoms :    5 (   5 avg)
%            Number of connectives :    7 (   0   ~;   0   |;   0   &;   4   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    6 (   6 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :    3 (   3   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    4 (   3 usr;   1 con; 0-2 aty)
%            Number of variables   :    1 (   0   ^;   1   !;   0   ?;   1   :)
% SPC      : TH0_CSA_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
%          : 
%------------------------------------------------------------------------------
thf(a_type,type,
    a: $tType ).

thf(cF,type,
    cF: a > $o ).

thf(cJ,type,
    cJ: ( a > $o ) > a ).

thf(cX,type,
    cX: a ).

thf(cDESCR_CHURCH,conjecture,
    ( ( cF @ cX )
   => ( ! [Y: a] :
          ( ( cF @ Y )
         => ( cX = Y ) )
     => ( cF @ ( cJ @ cF ) ) ) ) ).

%------------------------------------------------------------------------------
